'use strict'

entityRegistry['module']['stretchFit'] = {
    extendedInfo: {
        displayName: 'Stretch',
        displayGroup: 'Post Processing',
    },
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const colorBuffer = renderer.getCurrentBuffer('color')
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')

            const width = colorBuffer.width
            for (let y = 0; y < colorBuffer.height; ++y) {
                let index = y * width
                for (let x = 0; x < width; ++x) {
                    const color = colorBuffer.data[index]
                    if (color) {
                        let brightness = brightnessBuffer.data[index]
                        for (; x > 0; --x) {
                            --index
                            colorBuffer.data[index] = color
                            brightnessBuffer.data[index] = brightness
                            brightness *= .992
                        }
                        break
                    }
                    index++
                }

                index = y * width + width - 1
                for (let x = width - 1; x >= 0; --x) {
                    const color = colorBuffer.data[index]
                    if (color) {
                        let brightness = brightnessBuffer.data[index]
                        for (; x < width; ++x) {
                            colorBuffer.data[index] = color
                            brightnessBuffer.data[index] = brightness
                            brightness *= .992
                            brightness *= .99
                            ++index
                        }
                        break
                    }
                    index--
                }
            }
        }
    }
}
